	
****************************************************************************************************************************
* Figure 9. Wage PC
***********************************************************************

***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_quarterly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

g sample1 = 1 if (t>=tq(1968q1)) & (t<=tq(1972q4))
g sample2 = 1 if (t>=tq(1973q1)) & (t<=tq(1984q4))
g sample3 = 1 if (t>=tq(1985q1)) & (t<=tq(2019q4))
g sample4 = 1 if (t>=tq(2020q1)) & (t<=tq(2022q3))

g sample13 = 1 if (sample1==1 | sample3==1)

* Overall sample
keep if (t>=tq(1968q1)) & (t<=tq(2022q3))

***************************************************************
* Scatters: V/U
***************************************************************

* Define PC variables:
cap drop y x*
g y		= gw-pe
g x		= vu_4qa
g x2	= x^2
g x3	= x^3
local bwidth = 0.4
local xtitle = "V/U"

//*
preserve
local index = 1
local title = ""
* Drop outlier based on scatter plot
drop if t==tq(1972q1)
twoway ///
(scatter y x if sample1==1, mcolor(emidblue) msymbol(D)) ///
(scatter y x if sample2==1, mcolor(eltblue) msymbol(O)) ///
(scatter y x if sample3==1, mcolor(blue*.6) msize(small) msymbol(Oh)) ///
(scatter y x if sample4==1, yline(0, lcolor(ebg)) mcolor(red)) ///
(line y x if sample4==1, lcolor(red) lpattern(dash)) ///
(scatter y x if sample4==1, mcolor(red) mlabel(t) mlabposition(12) mlabcolor(red) xtitle("`xtitle'") ytitle("Wage inflation gap") ///
legend(row(4) symxsize(4) ring(0) position(1) bmargin(none) region(style(none))) ///
legend(label(1 "1968-72") label(2 "1973-84") label(3 "1985-2019") label(4 "2020-22") order(1 2 3 4)) ///
legend(position(5)) ///
xsize(4) ///
title("`title'", size(medsmall)) ///
saving(`index'.gph, replace))
keep if sample1==1|sample2==1|sample3==1|sample4==1
outsheet y x t using "results\charts\Figure 9.xls", replace
restore
*/	
